package com.ElyStudio.leGaou.adapter;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.card.MaterialCardView;
import com.ElyStudio.leGaou.R;
import com.ElyStudio.leGaou.activities.MainActivity;
import com.ElyStudio.leGaou.models.AppLanguage;
import com.ElyStudio.leGaou.utilities.Constants;
import com.ElyStudio.leGaou.utilities.LanguageManager;

import java.util.List;

public class AppLanguageAdapter extends RecyclerView.Adapter<AppLanguageAdapter.AppLanguageViewHolder> {

    private final Context context;
    private final Activity activity;
    private final List<AppLanguage> appLanguageList;

    public AppLanguageAdapter(Context context, Activity activity, List<AppLanguage> appLanguageList) {
        this.context = context;
        this.activity = activity;
        this.appLanguageList = appLanguageList;
    }

    SharedPreferences sharedPreferences;


    @NonNull
    @Override
    public AppLanguageAdapter.AppLanguageViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new AppLanguageViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.language_card_layout,parent,false));
    }

    @Override
    public void onBindViewHolder(@NonNull AppLanguageAdapter.AppLanguageViewHolder holder, int position) {
        sharedPreferences = activity.getSharedPreferences(Constants.appPrefs,Context.MODE_PRIVATE);
        String selectedLanguage = sharedPreferences.getString(Constants.appLanguage,Constants.DEFAULT_APP_LANGUAGE);
        LanguageManager languageManager = new LanguageManager(context);

        AppLanguage language = appLanguageList.get(position);
        holder.languageName.setText(language.getLanguageName());

        if(language.getLanguageCode().equals(selectedLanguage))
        {
            holder.languageName.setTextColor(context.getResources().getColor(R.color.white));
            holder.appLanguageCard.setCardBackgroundColor(context.getResources().getColor(R.color.primary));
            holder.selectedLanguageIcon.setVisibility(View.VISIBLE);
        }

        holder.appLanguageCard.setOnClickListener(v -> {
            languageManager.updateLanguage(language.getLanguageCode());
            activity.startActivity(new Intent(activity,MainActivity.class));
            activity.finish();
        });

    }

    @Override
    public int getItemCount() {
        return appLanguageList.size();
    }

    public static class AppLanguageViewHolder extends RecyclerView.ViewHolder {

        MaterialCardView appLanguageCard;
        TextView languageName;
        ImageView selectedLanguageIcon;

        public AppLanguageViewHolder(@NonNull View itemView) {
            super(itemView);

            languageName = itemView.findViewById(R.id.languageName);
            appLanguageCard = itemView.findViewById(R.id.languageCard);
            selectedLanguageIcon = itemView.findViewById(R.id.languageSelectedIcon);

        }
    }
}
